<?php
defined('PF_VERSION') OR exit('Access denied');
define('PLUGIN_PLUGINS', __('Plugins', 'plugin'));

class Plugin_Plugin extends Pf_Plugin {
    
    public $name = PLUGIN_PLUGINS;
    public $version = '1.0';
    public $author = 'PageFlex Team';
    public $description = 'This is plugin system';
    public function admin_init() {
        if(is_admin()){
            $this->admin_menu ( 'fa fa-cogs', __('Plugins', 'plugin'), 'plugins', 'plugin_manager_init' );
        }
    }
    public function plugin_manager_init() {
        $this->js('admin/themes/default/assets/bootbox/bootbox.min.js');
        $this->js('includes/common/plugin/assets/base.js');
        $plugins = get_plugins ( PLUGIN_PATH );
        $action = (! empty ( $_GET ['action'] )) ? $_GET ['action'] : '';
        $plugin = (! empty ( $_GET ['plugin'] )) ? urldecode ( $_GET ['plugin'] ) : '';
        $page = (! empty ( $_GET ['page'] )) ? $_GET ['page'] : '1';
        $plugin_status = (! empty ( $_GET ['plugin_status'] )) ? $_GET ['plugin_status'] : 'all';
        $str_search = '';
        if (! empty ( $_REQUEST ['pf_search'] )) {
            $str_search = '&pf_search=' . $_REQUEST ['pf_search'];
        }
        
        switch ($action) {
            case 'active' :
                if (array_key_exists ( $plugin, $plugins )) {
                    $actived_plugins = get_option ( 'active_plugins' );
                    if (! empty ( $actived_plugins ) && is_array ( $actived_plugins )) {
                        if (! in_array ( $plugin, $actived_plugins )) {
                            $actived_plugins [] = $plugin;
                            update_option ( 'active_plugins', $actived_plugins );
                        }
                    } else {
                        $actived_plugins = array ();
                        $actived_plugins [] = $plugin;
                        update_option ( 'active_plugins', $actived_plugins );
                    }
                }
                
                $plugin_file = PLUGIN_PATH . '/' . $plugin;
                $plugin = explode ( '/', trim ( $plugin ) );
                if (is_array ( $plugin ) && count ( $plugin ) == 2) {
                    $plugin_names = explode('-', $plugin [0]);
                    $plugin_names = array_map('strtolower', $plugin_names);
                    $plugin_names = array_map('ucfirst', $plugin_names);
                    $class = implode('_', $plugin_names) . '_Plugin';
                    if (! class_exists ( $class )) {
                        require $plugin_file;
                    }
                    if (class_exists ( $class )) {
                        $object = new $class ();
                        if (method_exists ( $object, 'activate' )) {
                            $object->activate ();
                        }
                    }
                }
                
                header ( "Location: ?admin-page=" . $_GET ['admin-page'] . "&plugin_status=" . $plugin_status . "&page=" . $page . $str_search );
                exit ();
                break;
            case 'deactive' :
                $actived_plugins = get_option ( 'active_plugins' );
                if (! empty ( $actived_plugins ) && is_array ( $actived_plugins )) {
                    if (in_array ( $plugin, $actived_plugins )) {
                        if (($key = array_search ( $plugin, $actived_plugins )) !== false) {
                            unset ( $actived_plugins [$key] );
                            update_option ( 'active_plugins', $actived_plugins );
                        }
                    }
                }
                
                $plugin_file = PLUGIN_PATH . '/' . $plugin;
                $plugin = explode ( '/', trim ( $plugin ) );
                if (is_array ( $plugin ) && count ( $plugin ) == 2) {
                    $plugin_names = explode('-', $plugin [0]);
                    $plugin_names = array_map('strtolower', $plugin_names);
                    $plugin_names = array_map('ucfirst', $plugin_names);
                    $class = implode('_', $plugin_names) . '_Plugin';
                    if (! class_exists ( $class )) {
                        require $plugin_file;
                    }
                    if (class_exists ( $class )) {
                        $object = new $class ();
                        if (method_exists ( $object, 'deactivate' )) {
                            $object->deactivate ();
                        }
                    }
                }
                
                header ( "Location: ?admin-page=" . $_GET ['admin-page'] . "&plugin_status=" . $plugin_status . "&page=" . $page . $str_search );
                exit ();
                break;
            default :
                $this->plugin_list_table ( $plugins );
                break;
        }
    }
    public function plugin_list_table($plugins) {
        $actived_plugins = get_option ( 'active_plugins' );
        $page = (! empty ( $_GET ['page'] )) ? $_GET ['page'] : '1';
        $plugin_status = (! empty ( $_GET ['plugin_status'] )) ? $_GET ['plugin_status'] : 'all';
        $pf_search = (! empty ( $_REQUEST ['pf_search'] )) ? $_REQUEST ['pf_search'] : '';
        
        if (! is_array ( $actived_plugins ))
            $actived_plugins = array ();
        
        $str_search = '';
        if (! empty ( $_REQUEST ['pf_search'] )) {
            $plugins = array_filter ( $plugins, 'search_plugin_callback' );
            
            $actived_plugins_tmp = array ();
            
            foreach ( $plugins as $k => $v ) {
                if (in_array ( $k, $actived_plugins )) {
                    $actived_plugins_tmp [$k] = $v;
                }
            }
            
            $actived_plugins_tmp = array_filter ( $actived_plugins_tmp, 'search_plugin_callback' );
            
            $actived_plugins = array_keys ( $actived_plugins_tmp );
            
            $str_search = '&pf_search=' . $_REQUEST ['pf_search'];
        }
        $tmp = $plugins;
        switch ($plugin_status) {
            case 'active' :
                $tmp = array ();
                foreach ( $plugins as $k => $v ) {
                    if (in_array ( $k, $actived_plugins )) {
                        $tmp [$k] = $v;
                    }
                }
                
                break;
            case 'inactive' :
                $tmp = array ();
                foreach ( $plugins as $k => $v ) {
                    if (! in_array ( $k, $actived_plugins )) {
                        $tmp [$k] = $v;
                    }
                }
                break;
        }
        
        $total = count ( $tmp );
        
        $total_page = ceil ( $total / NUM_PER_PAGE );
        
        if ($page > $total_page) {
            $_GET ['page'] = $page = $total_page;
        }
        $start = ($page - 1) * NUM_PER_PAGE;
        $tmp = array_slice ( $tmp, $start, NUM_PER_PAGE );
        $pages = new PF_Paginator ( $total, NUM_PER_PAGE, 'page' );
        
        require abs_plugin_path(__FILE__).'/plugin/templates/index.php';
    }
}
function search_plugin_callback($plugin) {
    $term = trim ( $_REQUEST ['pf_search'] );
    if (stripos ( $plugin ['name'], $term ) !== false)
        return true;
    
    return false;
}

